% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualBivarTimeToEvent.R
\name{visualBivarTimeToEvent}
\alias{visualBivarTimeToEvent}
\title{Plots bivariate right-censored data.}
\usage{
visualBivarTimeToEvent(X, Y, deltaX, deltaY, labelX, labelY,
   xlim = NULL, ylim = NULL, dotSize = 0.7,
   segLength=abs(mean(diff(c(X, Y)))), scaleLegendGap = 1,
   legendCex = 1, labCex = 1, axisCex = 1)
}
\arguments{
\item{X}{Time to event or censoring for variable \code{X}. It indicates time to event if argument \code{deltaX}=1 and time to censoring if argument \code{deltaX}=0.}

\item{Y}{Time to event or censoring for variable \code{Y}. It indicates time to event if argument \code{deltaY}=1 and time to censoring if argument \code{deltaY}=0.}

\item{deltaX}{Event indicator for variable \code{X}. \code{deltaX=1} if the event is observed and \code{0} if it is censored.}

\item{deltaY}{Event indicator for variable \code{Y}. \code{deltaY=1} if the event is observed and \code{0} if it is censored.}

\item{labelX}{Label for the X event.}

\item{labelY}{Label for the Y event.}

\item{xlim}{The range for the X-axis (the same as parameter \code{xlim} in function \code{plot()}).}

\item{ylim}{The range on the X-axis (the same as parameter \code{ylim} in function \code{plot()}).}

\item{dotSize}{The size of the points (the same as parameter \code{cex} in function \code{points()}).}

\item{segLength}{The length of the segment representing censored observations.}

\item{scaleLegendGap}{Increases (if > 1) or decreases (if < 1) the distance between the labels in the legend;}

\item{legendCex}{The size of the legend font (the same as parameter \code{cex} in function \code{text()}).}

\item{labCex}{The size of \code{xlab} and \code{ylab} (the same as parameter \code{cex.lab} in function \code{plot()}).}

\item{axisCex}{The size of axis labels (the same as parameter \code{cex.axis} in function \code{plot()}).}
}
\value{
None
}
\description{
Plots bivariate right-censored data distinguishing between uncensored, singly censored, and doubly censored observations.
}
\details{
Plots bivariate right-censored data distinguishing between uncensored, singly censored,
and doubly censored observations. The singly and doubly censored observations are plotted
 as diamonds and squares, respectively, with a short segment on the right,
 which length is the same for X and Y.
 The legend is always plotted in the left upper corner.
}
\examples{
X = c(0.5, 0.61, 0.6, 0.8, 0.78, 0.7, 0.9)
Y = c(0.44, 0.15, 0.77, 0.88, 0.22, 0.99, .33)
deltaX = c(1, 0, 1, 1, 0, 1, 0)
deltaY = c(1, 0, 1, 0, 1, 1, 1)

visualBivarTimeToEvent(X, Y, deltaX, deltaY, xlim = c(0, 1), ylim = c(0, 1),
                       labelX = "X", labelY = "Y", segLength = 0.05)

}
\author{
Svetlana K Eden, \email{svetlanaeden@gmail.com}
}
\keyword{bivariate}
\keyword{data}
\keyword{plot}
