% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crisk_cat.R
\name{crisk_cat}
\alias{crisk_cat}
\title{Modify the Output for Uni-variable and Multi-variable Competing Risk Analysis (Categorical Only)}
\usage{
crisk_cat(
  csurv,
  cevent,
  cvars,
  gnames,
  month = 0,
  y1 = TRUE,
  y2 = TRUE,
  y5 = TRUE
)
}
\arguments{
\item{csurv}{the duration of follow-up time in months.}

\item{cevent}{the status indicator, which is generally 0 = alive, 1 = event, 2 = other event}

\item{cvars}{a vector, which has the variable's values (categorical only)}

\item{gnames}{a text string, which is the name of the variable.}

\item{month}{a number to get the month-rate of competing risk.}

\item{y1}{logical value indicating whether the 1-year competing risk rate should be reported.}

\item{y2}{logical value indicating whether the 2-year competing risk rate should be reported.}

\item{y5}{logical value indicating whether the 5-year competing risk rate should be reported.}
}
\value{
a tibble of competing risk analysis output.
}
\description{
This function generates a table of competing risk analysis result with number of patients,number of event, number of competing event,
}
\examples{
Dat <- MASS::Melanoma
Dat$time <- Dat$time/30.5
output <- crisk_cat(Dat$time, Dat$status, Dat$ulcer, "ulcer")

}
