% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Svplot2fg.R
\name{svplot2}
\alias{svplot2}
\title{Creates Sv-plot2, the second version of the sample variance plots.}
\usage{
svplot2(X,title="Sv-plot2",xlab="x",lbcol="grey5", lsdcol="grey60",
             rbcol="grey45",rsdcol="grey75",...)
}
\arguments{
\item{X}{an \eqn{n} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n}, where \eqn{n} is number of observations.}

\item{title}{title of the plot, \emph{Sv-plot2} by default.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{lbcol}{left bound color, \emph{grey5} by default.}

\item{lsdcol}{left squared deviation color, \emph{grey60} by default.}

\item{rbcol}{right bound color, \emph{grey45} by default.}

\item{rsdcol}{right squared deviation color, \emph{grey75} by default.}

\item{...}{other graphical parameters.}
}
\value{
Sv-plot2
}
\description{
Sv-plot2 identifies the characteristics of the distribution illustrating squared deviation values in the sample variance against each data value.
}
\examples{
   set.seed(0)
   X1 <- matrix(rnorm(50,mean=2,sd=5))
   svplot2(X1)

   X2 <- matrix(rf(50,df1=10,df2=5))
   svplot2(X2)

   X3 <- matrix(rbeta(50,shape1=10,shape2=2))
   svplot2(X3,lbcol="blue",lsdcol="blue",rbcol="red",rsdcol="red")
}
\references{
Wijesuriya, U. A. (2020). Sv-plots for identifying characteristics of the
            distribution and testing hypotheses. \emph{Communications in Statistics-Simulation and Computation}, \doi{10.1080/03610918.2020.1851716}.
}
