\name{swSiz}
\alias{swSiz}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Sample Size of Stepped Wedge Cluster Randomized Trial (SW CRT) for LMM
}
\description{
\code{swSiz} is a wrapper function for \code{swPwr}. For a given design, number of clusters, power and fixed and random effect parameters, \code{swSiz} computes the number of individuals per cluster needed to achieve the desired power.
}
\usage{
swSiz(power, alpha=0.05, ...)
%
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{power}{
numeric (scalar) Desired power. Must be between \eqn{\alpha} (default = 0.05) and 1.
}
  \item{alpha}{
numeric (scalar): Two-sided statistical significance level.
}
  \item{...}{
Arguments to be passed to \code{swPwr}. See documentation for \code{swPwr}.
}
}

\details{
\code{swSiz} calls \code{swPwr} iteratively to find the number of participants per cluster-period needed to achieve \code{power} power. Note that all warnings and messages normally generated by \code{swPwr} are turned off. Also, the argument \code{retDATA} is set to \code{FALSE}. It is recommended that after using \code{swSiz}, the user call \code{swPwr} with the recommended sample size to view any warning messages and/or to get the data normally returned when \code{retDATA} is \code{TRUE}. 

An error in \code{swPwr} causes \code{swSiz} to terminate and the error message from \code{swPwr} is printed. 
}

\value{

numeric (list): \code{swSiz} returns a list of the following:
%% *****SPECIFY WHAT THESE ARE!!!!!**********
	\item{n}{
		scalar: number of individuals per cluster-period required to achieve the desired power.
	}
	\item{power}{
		scalar: exact power, as computed by \code{swPwr}, obtained with the sample size \code{n}.
	}
}
\author{
Avi Kenny, James P Hughes
}
%\note{
%%  ~~further notes~~
%}
%
%% ~Make other sections like Warning with \section{Warning }{....} ~
%
%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
swSiz(power = 0.9, design = swDsn(clusters=c(4,4,4,4)),
  distn = "gaussian", mu0 = 0, mu1 = 0.1, sigma = 0.5, icc = 0.1)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ power }
\keyword{ stepped wedge }% __ONLY ONE__ keyword per line
\keyword{ cluster randomized trial }
