% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heading.R
\name{heading}
\alias{heading}
\title{Headings}
\usage{
heading(x, y, geo = FALSE)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates corresponding to a single 
trajectory.}

\item{y}{A vector of y (or latitude) coordinates corresponding to a single 
trajectory.}

\item{geo}{A logical value indicating whether the locations are defined by 
geographic coordinates (pairs of longitude/latitude values). Default: FALSE.}
}
\value{
A vector of the same length as x and y corresponding to the 
 approximated headings along the trajectory.
}
\description{
Given a set of locations defining a trajectory, this function 
 approximates their instantaneous headings computed as the direction of the 
 vectors between successive locations along the trajectory.
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
heading(x, y)

}
\seealso{
\code{\link{ang_speed}}, \code{\link{ang_acc}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
