% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpl.R
\name{read_gpl}
\alias{read_gpl}
\title{Read colors from GIMP Palette (GPL) files}
\usage{
read_gpl(path, use_names = TRUE, .verbose = FALSE)
}
\arguments{
\item{path}{partial or full file path or URL to a GPL file}

\item{use_names}{add color names to the vector (defaults to \code{TRUE}). See NOTE}

\item{.verbose}{show extra information about GPL file processing}
}
\description{
Given a path or URL to an \code{.gpl} file, this function will return
a named character vector (if color names are present) of hex RGB colors.
}
\note{
When using named color palettes in a \code{ggplot2} \code{scale_} context, you
    must \code{unname}, set \code{use_names} to \code{FALSE} or override their names
    to map to your own factor levels. Also, Neither Lab nor greyscale colors are supported.
}
\examples{
# built-in palette
gimp16 <- read_gpl(system.file("palettes", "base16.gpl", package="swatches"))
print(gimp16)
show_palette(gimp16)

# from the internet directly
\dontrun{
bright <- read_gpl(URL)
print(bright)
show_palette(bright)
}
}
