% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.msel}
\alias{predict.msel}
\title{Predict method for msel function}
\usage{
\method{predict}{msel}(
  object,
  ...,
  newdata = NULL,
  given_ind = numeric(),
  group = NA,
  group2 = NA,
  group3 = NA,
  type = ifelse(any(is.na(group2)), "prob", "val"),
  me = NULL,
  eps = NULL,
  control = list(),
  test = FALSE,
  exogenous = NULL
)
}
\arguments{
\item{object}{an object of class "msel".}

\item{...}{further arguments (currently ignored)}

\item{newdata}{an optional data frame in which to look for variables 
with which to predict. If omitted, the original data frame used.
This data frame should contain values of dependent variables even if
they are not actually needed for prediction 
(simply assign them with 0 values).}

\item{given_ind}{a numeric vector of indexes of conditioned components.}

\item{group}{a numeric vector which i-th element represents a value of the
i-th dependent variable. If this value equals -1 then this component
will be ignored (useful for estimation of marginal probabilities).}

\item{group2}{a numeric vector which i-th element represents a value of the
i-th dependent variable of the continuous equation. 
If this value equals -1 then this component will be ignored.}

\item{group3}{an integer representing the index of the alternative of the
multinomial equation. If this value equals -1 then this component will be 
ignored.}

\item{type}{a string representing a type of the prediction.
See 'Details' for more information.}

\item{me}{a string representing the name of the variable for which marginal
effect should be estimated. See 'Details' for more information.}

\item{eps}{a numeric vector of length 1 or 2 used for calculation of
the marginal effects. See 'Details' for more information.}

\item{control}{a list of additional arguments. Currently is not intended
for the users.}

\item{test}{a logical, function or integer. If \code{test = TRUE} then the 
output of the function is supplied to 
\code{\link[switchSelection]{test_msel}} before return to perform a t-test.
If \code{test} is a function it will be applied to the output of the 
\code{predict} before \code{\link[switchSelection]{test_msel}} is called.
If \code{test} is an integer then \code{\link[switchSelection]{test_msel}}
will be applied only to the \code{test}-th column of the output.}

\item{exogenous}{a list such that \code{exogenous[[i]]} represents the value 
(or a vector of values of the same size as \code{nrow(newdata)}) which will 
be exogenously assigned to the variable \code{names(exogenous)[[i]]} in 
\code{newdata} i.e., \code{newdata[, names(exogenous)[i]] <- exogenous[[i]]}.
If \code{newdata} is \code{NULL} and \code{exogenous} is not \code{NULL} then
\code{newdata} is set to \code{object$data}.
This argument is especially useful for the casual inference when some 
endogenous (dependent) variables should be exogenously assigned with some 
values i.e., in the right hand side of the \code{formula}, \code{formula2} 
and \code{formula3}. The purpose of \code{exogeneous} argument is just a 
convenience so equivalently it is possible to exogenously provide the values
to variables via the \code{newdata} argument.}
}
\value{
This function returns predictions for each row of \code{newdata}
or for each observation in the model if \code{newdata} is \code{NULL}.
Structure of the output depends on the \code{type} argument
(see 'Details' section).
}
\description{
Predicted values based on the object of class 'msel'.
}
\details{
See 'Examples' section of \code{\link[switchSelection]{msel}}
for the examples of this function application.

\strong{Probabilities of the multivariate ordinal equations}

If \code{type = "prob"} then the function returns a joint probability that 
the ordinal outcomes will have values assigned in \code{group}. To calculate
marginal probabilities set unnecessary \code{group} values to \code{-1}. 

To estimate conditional probabilities provide indexes of the conditioned 
outcomes through the \code{given_ind} argument. 

For example, if \eqn{z_{1i}}, \eqn{z_{2i}} and \eqn{z_{3i}} are the ordinal
outcomes then to estimate 
\eqn{P(z_{1i}=2 | z_{3i} = 0, w_{1i}, w_{2i}, w_{3i})} set 
\code{given_ind = 3} and \code{groups = c(2, -1, 0)}.

\strong{Linear predictors (indexes) of the multivariate ordinal equations}

If \code{type = "li"} or \code{type = "lp"} then the function returns a 
matrix which columns are linear predictors (indexes) of the corresponding 
equations. If \code{group[j] = -1} then linear predictors (indexes) 
associated with the \code{j}-th ordinal equation will be omitted from the 
output.

For example, if \code{group = c(0, -1, 1)} then the function returns a
matrix which first column is \eqn{w_{1i}\hat{\gamma}_{1}} and the second 
column is \eqn{w_{3i}\hat{\gamma}_{3}}.

\strong{Standard deviations of the multivariate ordinal equations}

If \code{type = "sd"} then the function returns a matrix which columns are
the estimates of the standard deviations of the random errors for 
the corresponding equations. 
If \code{group[j] = -1} then the standard deviations associated with the 
\code{j}-th ordinal equation will be omitted from the output.

For example, if \code{group = c(0, -1, 1)} then the function returns a
matrix which first column is \eqn{\hat{\sigma}_{1i}^{*}} and the second 
column is \eqn{\hat{\sigma}_{3i}^{*}}.

\strong{Predictions of the continuous outcomes}

If \code{type = "val"} then the function returns the predictions of the 
conditional (on \code{group}) expectation of the continuous outcomes in the 
regimes determined by the \code{group2} argument. To predict unconditional 
expectations set \code{group} to a vector of \code{-1} values.

For example, suppose that there is a single continuous equation \eqn{y_{i}} 
and two ordinal equations \eqn{z_{1i}} and \eqn{z_{2i}}. 
To estimate \eqn{E(y_{2i}|x_{i})} set \code{group = c(-1, -1)} and 
\code{group2 = 2}. 
To estimate \eqn{E(y_{1i}|x_{i}, z_{1i} = 2, z_{2i} = 0)} set 
\code{group = c(2, 0)} and \code{group2 = 1}.
To estimate \eqn{E(y_{0i}|x_{i}, z_{2i} = 1)} set 
\code{group = c(-1, 1)} and \code{group2 = 0}.

Suppose that there are two continuous \eqn{y_{i}^{(1)}},
\eqn{y_{i}^{(2)}} and two ordinal \eqn{z_{1i}}, \eqn{z_{2i}} equations.
If \code{group2 = c(1, 3)} and \code{group = c(3, 0)} then the function 
returns a matrix which first column are the estimates of 
\eqn{E(y_{1i}^{(1)}|z_{1i} = 3, z_{2i} = 0, x_{i}^{(1)})} and the second 
column are the estimates of 
\eqn{E(y_{3i}^{(2)}|z_{1i} = 3, z_{2i} = 0, x_{i}^{(2)})}.

\strong{Selectivity terms}

If \code{type = "lambda"} then the function returns a matrix which 
\code{j}-th column is a numeric vector of estimates of the selectivity terms 
\eqn{\lambda_{ji}} associated with the ordinal equations. 
Similarly if \code{type = "lambda_mn"} then the
function returns a numeric matrix with the selectivity terms of the 
multinomial equations.

\strong{Probabilities of the multinomial equation}

If \code{type = "prob_mn"} and \code{group3 = j} then the function returns 
a vector of the estimates of the probabilities 
\eqn{P(\tilde{z}_{i}=j|\tilde{w}_{i})}.

\strong{Linear indexes (predictors) of the multinomial equation}

If \code{type = "li_mn"} or \code{type = "lp_mn"} then the function returns a 
numeric matrix which \code{j}-th column is a numeric vector of estimates of 
the linear predictor (index) associated with the \code{(j-1)}-th alternative 
\eqn{\tilde{w}_{i}\tilde{\gamma}_{(j-1)}}.

\strong{Estimation of the marginal effects}

If \code{me} is provided then the function returns marginal effect
of variable \code{me} respect to the statistic determined by the \code{type}
argument. 

For example, if \code{me = "x1"} and \code{type = "prob"} then the function 
returns a marginal effect of \code{x1} on the corresponding probability 
i.e., one that would be estimated if \code{me} is \code{NULL}.

If \code{length(eps) = 1} then \code{eps} is an increment in 
numeric differentiation procedure. 
If \code{eps} is \code{NULL} then this increment will be selected 
automatically taking into account scaling of variables. 
If \code{length(eps) = 2} then marginal effects will be estimated as the
difference of predicted value when variable \code{me} equals \code{eps[2]}
and \code{eps[1]} correspondingly. 

For example, suppose that 
\code{type = "prob"}, \code{me = "x1"}, \code{given_ind = 3} and
\code{groups = c(2, -1, 0)}. Then if \code{eps} is a \code{NULL} or a 
small number (something like \code{eps = 0.0001}) then the following marginal
effect will be estimated (via the numeric differentiation):
\deqn{\frac{\partial P(z_{1i}=2 | z_{3i} = 0)}{\partial x_{1i}}.}
If \code{eps = c(1, 3)} then the function estimates the following difference
(useful for estimation of marginal effects of ordered covariates):
\deqn{P(z_{1i}=2 | z_{3i} = 0, x_{1i} = 3) - 
      P(z_{1i}=2 | z_{3i} = 0, x_{1i} = 1).}
Notice that the conditioning on \eqn{w_{ji}} has been omitted for brevity.
 
\strong{Causal inference}

Argument \code{exogenous} is useful for the causal inference. 
For example, suppose that there are two binary outcomes \eqn{z_{1i}} and
\eqn{z_{2i}}. Also \eqn{z_{1i}} is the endogenous regressor for \eqn{z_{2i}}.
That is \eqn{z_{1i}} appears both on the left hand side of
\code{formula[[1]]} and on the right hand side of \code{formula[[2]]}. 
Consider the estimation of the average treatment effect:
\deqn{ATE = P(z_{2i} = 1|do(z_{1i}) = 1) - 
P(z_{2i} = 1|do(z_{1i}) = 0),}
where \eqn{do} is a do-calculus operator.
The estimate of the average treatment effect is as follows:
\deqn{\widehat{ATE} = \frac{1}{n}\sum\limits_{i=1}^{n}p_{1i}-p_{0i},}
where:
\deqn{p_{1i} = \hat{P}(z_{2i} = 1|do(z_{1i}) = 1, w_{1i}, w_{2i}^{(*)}),}
\deqn{p_{0i} = \hat{P}(z_{2i} = 1|do(z_{1i}) = 0, w_{1i}, w_{2i}^{(*)}).}

Vector \eqn{w_{2i}^{(*)}} denotes all the regressors \eqn{w_{2i}} except
the endogenous one \eqn{z_{1i}}.

To get \eqn{\widehat{ATE}} it is sufficient to make the following steps. 
First, calculate \eqn{p_{1i}} by setting \code{type = "prob"}, 
\code{group = c(-1, 1)} and providing the value \code{1} to \eqn{z_{1i}} 
through the \code{exogenous} argument. 
Second, calculate \eqn{p_{0i}} by setting \code{type = "prob"}, 
\code{group = c(-1, 0)} and providing the value \code{0} to \eqn{z_{1i}} 
through the \code{exogenous} argument. Third, take the average value of 
\eqn{p_{1i}-p_{0i}}.
}
