% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_participantgroup.R
\name{create_participantgroup}
\alias{create_participantgroup}
\title{Create a ParticipantGroup instance using long-format data}
\usage{
create_participantgroup(
  raw_df,
  n_trials_per_grapheme = 3,
  id_col_name,
  symbol_col_name,
  color_col_name,
  time_col_name = NULL,
  color_space_spec = "Luv"
)
}
\arguments{
\item{raw_df}{A data frame of 'long format' raw consistency test data.}

\item{n_trials_per_grapheme}{A one-element numeric vector holding the number
of trials per grapheme that was used in the consistency test the data are from.}

\item{id_col_name}{A one-element character vector that holds the
name of the participant id column in raw_df.}

\item{symbol_col_name}{A one-element character vector that holds the
name of the grapheme/symbol column in raw_df.}

\item{color_col_name}{A one-element character vector that holds the
name of the response color (hex codes) column in raw_df.}

\item{time_col_name}{(optional) A one-element character vector that holds the
name of the response time (time from stimulus presentation to response) column
in raw_df.}

\item{color_space_spec}{A one-element character vector specifying which color
space to use for calculations with participant data. One of
"XYZ", "sRGB", "Apple RGB", "Lab", and "Luv".}
}
\description{
Takes in a data frame of raw
\href{https://stefvanbuuren.name/fimd/sec-longandwide.html}{'long format'}
consistency test data and returns a
ParticipantGroup instance, to which all the relevant data are linked. See the
example data frame `synr_exampledf_long_small` and its documentation
(`help(synr_exampledf_long_small)`) for more information on the format
that this function expects data to be in.
}
\examples{
pg <- create_participantgroup(
  raw_df=synr_exampledf_long_small,
  n_trials_per_grapheme=2,
  id_col_name="participant_id",
  symbol_col_name="trial_symbol",
  color_col_name="response_color",
  time_col_name="response_time",
  color_space_spec="Luv"
)
cons_means <- pg$get_mean_consistency_scores()
print(cons_means)
}
