% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.estpoly}
\alias{predict.estpoly}
\title{Predictions of identified model}
\usage{
\method{predict}{estpoly}(object, newdata = NULL, nahead = 1, ...)
}
\arguments{
\item{object}{\code{estpoly} object containing the identified model}

\item{newdata}{optional dataset to be used for predictions. If not supplied, 
predictions are made on the training set.}

\item{nahead}{number of steps ahead at which to predict (Default:1). For infinite-
step ahead predictions or pure simulation, supply \code{Inf}.}

\item{\ldots}{other arguments}
}
\value{
Time-series containing the predictions
}
\description{
Predicts the output of an identified model (\code{estpoly}) object K steps ahead.
}
\examples{
data(arxsim)
mod1 <- oe(arxsim,c(2,1,1))
Yhat <- predict(mod1,arxsim) #  1-step ahead predictions 
Yhat_2 <- predict(mod1,arxsim,nahead=2) # 2-step ahead predictions
Yhat_inf <- predict(mod1,arxsim,nahead=Inf) # Infinite-step ahead predictions

}
\references{
Arun K. Tangirala (2015), \emph{Principles of System Identification: Theory 
and Practice}, CRC Press, Boca Raton. Chapter 18
}

