% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count-values.R
\name{count_values}
\alias{count_values}
\alias{assert_single_value}
\title{Check for existence of multiple values per group}
\usage{
count_values(.data, col, by, setkey = FALSE)

assert_single_value(.data, col, by)
}
\arguments{
\item{.data}{A data frame or data table}

\item{col}{tidy-select. Columns in \code{.data}. When counting the number of unique
rows, only the columns specified in \code{col} are considered.}

\item{by}{tidy-select. Columns in \code{.data}.}

\item{setkey}{Logical. Should the output be keyed by \code{by} cols?}
}
\value{
\describe{
\item{\code{count_values()}}{A \code{data.table} with the (filtered)
\code{by} columns and an additional column "n_vals" which shows the number of
unique rows in \code{.data} having the combination of \code{by} values shown
in the output row.}

\item{\code{assert_single_value()}}{No return value. Called to throw an
error depending on the input.}
}
}
\description{
\code{count_values()} returns values of \code{by} variables for which the \code{.data} has
multiple unique rows, along with the number of unique rows for each
combination of values, only considering columns in \code{col}.

\code{assert_single_value()} throws an error if there are multiple unique rows for
any combination of \code{by} variable values, only considering columns in \code{col}.
}
\examples{
df <- read.table(text = "
x y z
a 1 3
a 1 3
a 2 4
a 2 4
a 2 2
b 1 1
b 1 2
", header = TRUE)

count_values(df, z, by = c(x, y))

\dontrun{
assert_single_value(df, z, by = c(x, y))
}

}
