% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{format_column}
\alias{format_column}
\title{format_column}
\usage{
format_column(
  tbl,
  columns = dplyr::everything(),
  rows = NULL,
  format_gt = gt::fmt_auto,
  format_openxlsx = "GENERAL",
  stack = TRUE
)
}
\arguments{
\item{tbl}{tablespan table}

\item{columns}{the columns to style. Must be a tidyselect selector expression (e.g., starts_with("hp_"))}

\item{rows}{indices of the rows which should be styled. When set to NULL, the style is applied to all rows}

\item{format_gt}{formatting used for gt. This must be a function with the following signature: function(tbl, columns, rows, ...)
and return the tbl with applied formatting. See examples.}

\item{format_openxlsx}{an argument passed to the numFmt field for openxlsx::createStyle.}

\item{stack}{When set to TRUE, the style is added on top of the existing styles. This is mostly relevant
for openxlsx. When set to FALSE, the new style replaces all previous styling.}
}
\value{
the tablespan table with added styles
}
\description{
Change the formatting of a column or single cells within columns.
}
\examples{
library(tablespan)
library(dplyr)
data("mtcars")

# We want to report the following table:
summarized_table <- mtcars |>
  group_by(cyl, vs) |>
  summarise(N = n(),
            mean_hp = mean(hp),
            sd_hp = sd(hp),
            mean_wt = mean(wt),
            sd_wt = sd(wt))

# Create a tablespan:
tbl <- tablespan(data = summarized_table,
                 formula = Cylinder:cyl + Engine:vs ~
                   N +
                   (`Horse Power` = Mean:mean_hp + SD:sd_hp) +
                   (`Weight` = Mean:mean_wt + SD:sd_wt),
                 title = "Motor Trend Car Road Tests",
                 subtitle = "A table created with tablespan",
                 footnote = "Data from the infamous mtcars data set.")

tbl |>
  format_column(columns = mean_hp,
                rows = c(1,3),
                format_gt = function(tbl, columns, rows, ...){
                             return(gt::fmt_number(tbl,
                                       columns = columns,
                                       rows = rows,
                                       decimals = 4))},
                format_openxlsx = "0.0000") |>
  as_gt()
}
