% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other.R
\name{dataKNMI}
\alias{dataKNMI}
\title{Wind speeds in the Netherlands.}
\format{
dataKNMI$data is a matrix with 672 rows and 22 columns, dataKNMI$loc is a matrix with 22 rows
and 2 columns.
}
\source{
KNMI
}
\description{
Daily maximal speeds of wind gusts, measured in 0.1 m/s. The data are observed at
22 inland weather stations in the Netherlands. Only the summer months are presented
here (June, July, August). Also included are the Euclidian coordinates of the 22
weather stations, where a distance of 1 corresponds to 100 kilometers.
}
\examples{
data(dataKNMI)
n <- nrow(dataKNMI$data)
locations <- dataKNMI$loc
x <- apply(dataKNMI$data, 2, function(i) n/(n + 0.5 - rank(i)))
indices <- selectGrid(cst = c(0,1), d = 22, locations = locations, maxDistance = 0.5)
EstimationBR(x, locations, indices, k = 60, method = "Mestimator", isotropic = TRUE,
covMat = FALSE)$theta
}
\references{
Einmahl, J.H.J., Kiriliouk, A., Krajina, A., and Segers, J. (2016). An Mestimator of spatial tail dependence. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 78(1), 275-298.
}
