% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC.cr.R
\name{AUC.cr}
\alias{AUC.cr}
\title{Calculate Time-dependent ROC and AUC with competing risk}
\usage{
AUC.cr(X, W.prim, W.cmp, cut.off = NULL, n.grid = 1000, method)
}
\arguments{
\item{X}{a numeric vector of risk score ranging from 0 to 1 in the same length as \code{Y} and \code{delta}. A higher value indicates higher
higher risk of the event. It can be a biomarker value, a function of multiple value, or the predicted cumulative incidence
probability from a copeting risk regression model that we want to evaluate.}

\item{W.prim}{a numeric vector of weight for the primary event you want to study. It has the same length as \code{X}.
It should be generated by \code{td.kw.cr} with \code{event.code = 1}.}

\item{W.cmp}{a numeric vector of weight for the competing event. It has the same length as \code{X}.
It should be generated by \code{td.kw.cr} with \code{event.code = 2}.}

\item{cut.off}{a vector of risk score cut-off values at which sensitivity and specificity will be calculated. Default is \code{NULL},
and we set cut off point by  \code{n.grid} to calculate sensitivity and specificity.}

\item{n.grid}{a positive integer, the number of grid points used when calculating the ROC curve. The default is \code{1000}.}

\item{method}{}
}
\value{
Returns a list of the following items:

a list of \code{AUC.A.integral} estimated by trapezoidal integration for definition A,
       \code{AUC.A.empirical} estimated by nonparametric framework for definition A (Wu and Li, 2018),
        \code{AUC.B.integral} estimated by trapezoidal integration for definition B,
       \code{AUC.B.empirical} estimated by nonparametric framework for definition B (Wu and Li, 2018),
       and a data frame \code{ROC} with dimension \code{(2+n.grid) x 4} with columns \code{cut.off}, \code{sens}, \code{specA} and \code{specB}.
}
\description{
This function calculates the time-dependent sensitivity and specificity and area under the curve (AUC)
       using precalculated weights by \code{td.kw.cr}.
}
\details{
This function read in the risk score value \code{X}, estimated conditional probability for primary event \code{W.prim},
       and estimated conditional probability for competing event \code{W.cmp} to calculate sensitivity and specificity
       for a series specified grid points. Based on the definition of controls mentioned in Wu and Li, 2018, we separately
       calculate specificity and corresponding AUC for each definition. In addition, this function returns both the
       AUC estimated by trapezoidal integration and AUC estimated by nonparametric framework mentioned in Wu and Li, 2018.
}
\seealso{
\code{\link[survival]{survfit}}
}
\keyword{internal}
