% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avhill.R
\name{avhill}
\alias{avhill}
\title{Averaged Hill Plot}
\usage{
avhill(data, u = 2, kmin = 5, conf.int = FALSE)
}
\arguments{
\item{data}{vector of sample data}

\item{u}{gives the amount of which the Hill estimator is averaged. Default ist set to \code{u=2}.}

\item{kmin}{gives the minimal \code{k} for which the graph is plotted. Default ist set to \code{kmin=5}.}

\item{conf.int}{\code{logical}. If FALSE (default) no confidence intervals are plotted}
}
\value{
The normal black line gives the classical Hill Plot. The red dotted line is an averaged version that smoothes the Hill Plot by taking the mean of \code{k(u-1)} subsequent Hill estimations with respect to \code{k}. See references for more information.
}
\description{
Plots an averaged version of the classical Hill Plot
}
\details{
The Averaged Hill Plot is a smoothed version of the classical Hill Plot by taking the mean of values of the Hill estimator for subsequent \code{k}, i.e. upper order statistics. For more information see references.
}
\examples{
data(danish)
avhill(danish) 
}
\references{
Resnick, S. and Starica, C. (1997). Smoothing the Hill estimator. \emph{Advances in Applied Probability}, 271--293.
}
