% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_data-class.R
\docType{class}
\name{teal_data-class}
\alias{teal_data-class}
\title{Reproducible data}
\description{
Reproducible data container class. Inherits code tracking behavior from \code{\link[teal.code:qenv-class]{teal.code::qenv}}.
}
\details{
This class provides an isolated environment in which to store and process data with all code being recorded.
The environment, code, data set names, and data joining keys are stored in their respective slots.
These slots should never be accessed directly, use the provided get/set functions.

As code is evaluated in \code{teal_data}, messages and warnings are stored in their respective slots.
If errors are raised, a \code{qenv.error} object is returned.
}
\section{Slots}{

\describe{
\item{\code{.xData}}{(\code{environment}) environment containing data sets and possibly
auxiliary variables.
Access variables with \code{\link[=get]{get()}}, \code{\link{$}}, \code{\link[teal.code:get_var]{teal.code::get_var()}} or [\code{[[}].
No setter provided. Evaluate code to add variables into \verb{@.xData}.}

\item{\code{code}}{(\code{list} of \code{character}) representing code necessary to reproduce the contents of \code{qenv}.
Access with \code{\link[teal.code:get_code]{teal.code::get_code()}}.
No setter provided. Evaluate code to append code to the slot.}

\item{\code{join_keys}}{(\code{join_keys}) object specifying joining keys for data sets in
\verb{@.xData}.
Access or modify with \code{\link[=join_keys]{join_keys()}}.}

\item{\code{verified}}{(\code{logical(1)}) flag signifying that code in \verb{@code} has been
proven to yield contents of \verb{@.xData}.
Used internally. See \code{\link[=verify]{verify()}} for more details.}
}}

\section{Code}{



Each code element is a character representing one call. Each element is named with the random
identifier to make sure uniqueness when joining. Each element has possible attributes:
\itemize{
\item \code{warnings} (\code{character}) the warnings output when evaluating the code element.
\item \code{messages} (\code{character}) the messages output when evaluating the code element.
\item \code{dependency} (\code{character}) names of objects that appear in this call and gets affected by this call,
separated by \verb{<-} (objects on LHS of \verb{<-} are affected by this line, and objects on RHS are affecting this line).
}

}

\keyword{internal}
