% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_diff_test.R
\name{prop_diff_test}
\alias{prop_diff_test}
\alias{test_proportion_diff}
\alias{s_test_proportion_diff}
\alias{a_test_proportion_diff}
\title{Difference test for two proportions}
\usage{
test_proportion_diff(
  lyt,
  vars,
  variables = list(strata = NULL),
  method = c("chisq", "schouten", "fisher", "cmh"),
  var_labels = vars,
  na_str = default_na_str(),
  nested = TRUE,
  show_labels = "hidden",
  table_names = vars,
  section_div = NA_character_,
  ...,
  na_rm = TRUE,
  .stats = c("pval"),
  .stat_names = NULL,
  .formats = c(pval = "x.xxxx | (<0.0001)"),
  .labels = NULL,
  .indent_mods = c(pval = 1L)
)

s_test_proportion_diff(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  variables = list(strata = NULL),
  method = c("chisq", "schouten", "fisher", "cmh"),
  ...
)

a_test_proportion_diff(
  df,
  ...,
  .stats = NULL,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{method}{(\code{string})\cr one of \code{chisq}, \code{cmh}, \code{fisher}, or \code{schouten}; specifies the test used
to calculate the p-value.}

\item{var_labels}{(\code{character})\cr variable labels.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group
defined by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{...}{additional arguments for the lower level functions.}

\item{na_rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \code{'pval'}}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{flag})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}
}
\value{
\itemize{
\item \code{test_proportion_diff()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_test_proportion_diff()} to the table layout.
}

\itemize{
\item \code{s_test_proportion_diff()} returns a named \code{list} with a single item \code{pval} with an attribute \code{label}
describing the method used. The p-value tests the null hypothesis that proportions in two groups are the same.
}

\itemize{
\item \code{a_test_proportion_diff()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=test_proportion_diff]{test_proportion_diff()}} creates a layout element to test the difference between two
proportions. The primary analysis variable, \code{vars}, indicates whether a response has occurred for each record. See
the \code{method} parameter for options of methods to use to calculate the p-value. Additionally, a stratification
variable can be supplied via the \code{strata} element of the \code{variables} argument.
}
\section{Functions}{
\itemize{
\item \code{test_proportion_diff()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_test_proportion_diff()}: Statistics function which tests the difference between two proportions.

\item \code{a_test_proportion_diff()}: Formatted analysis function which is used as \code{afun} in \code{test_proportion_diff()}.

}}
\examples{
dta <- data.frame(
  rsp = sample(c(TRUE, FALSE), 100, TRUE),
  grp = factor(rep(c("A", "B"), each = 50)),
  strata = factor(rep(c("V", "W", "X", "Y", "Z"), each = 20))
)

# With `rtables` pipelines.
l <- basic_table() \%>\%
  split_cols_by(var = "grp", ref_group = "B") \%>\%
  test_proportion_diff(
    vars = "rsp",
    method = "cmh", variables = list(strata = "strata")
  )

build_table(l, df = dta)


## "Mid" case: 4/4 respond in group A, 1/2 respond in group B.
nex <- 100 # Number of example rows
dta <- data.frame(
  "rsp" = sample(c(TRUE, FALSE), nex, TRUE),
  "grp" = sample(c("A", "B"), nex, TRUE),
  "f1" = sample(c("a1", "a2"), nex, TRUE),
  "f2" = sample(c("x", "y", "z"), nex, TRUE),
  stringsAsFactors = TRUE
)
s_test_proportion_diff(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  variables = NULL,
  method = "chisq"
)

}
\seealso{
\link{h_prop_diff_test}
}
\keyword{internal}
