% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textBoxPlacement.R
\name{positionTextBoxDriverDriverDriver}
\alias{positionTextBoxDriverDriverDriver}
\title{positionTextBoxDriverDriverDriver}
\usage{
positionTextBoxDriverDriverDriver(
  xList,
  yList,
  textList,
  xPos,
  nApprox = 10,
  labs,
  sortB,
  verbose = FALSE
)
}
\arguments{
\item{xList}{(optional) list whose components are numeric vectors of the x values for overlaid curves}

\item{yList}{list whose components are numeric vectors of the y values for overlaid curves}

\item{textList}{(optional) list of character string texts to insert in plot}

\item{xPos}{(optional) numeric vector x position for text box}

\item{nApprox}{(optional) integer number of intervals to interpolate between x data points}

\item{labs}{(optional) list of labels annotating a graph
\itemize{
\item main character string main title
\item xlab character string x axis label
\item ylab character string y axis label
}}

\item{sortB}{Boolean if TRUE staggered curves reordered, with
largest range curve on bottom of graph}

\item{verbose}{Boolean if TRUE print informative or diagnostic messages to console}
}
\value{
returns no values, but has side effect of generating a graph.
}
\description{
Driver invoke positionTextBoxDriverDriver() using the original user input data
If that fails to produce an uncluttered plot, then invokes stagger() to reshape the data
before re-running positionTextBoxDriverDriver().
}
\details{
if xList or textList is missing, it is constructed from elements in yList

hint: to prevent conflicts, run the following line manually before running
positionTextBoxDriverDriverDriver()

rm(list=ls())

see https://stackoverflow.com/questions/27253376/different-results-from-rscript-and-r-cmd-batch
}
\examples{
# There is not enough space for text boxes in original graph.
# The package automatically adds offsets to the curves,
# keeping the curves in the original order,
# and successfully adds text boxes

positionTextBoxDriverDriverDriver(xList=xList1,yList=yList1,
  textList=textList,xPos=c(1,1,1),nApprox=10,labs=labs,sortB=FALSE)

# data set contains some negative values

positionTextBoxDriverDriverDriver(xList=xList2,yList=yList2,
  textList=textList,xPos=c(1,1,1),nApprox=10,labs=labs,sortB=FALSE)

# show the difference when we sort the order of the curves
# to position the curve with the largest range on the bottom

positionTextBoxDriverDriverDriver(xList=xList2,yList=yList2,
  textList=textList,xPos=c(1,1,1),nApprox=10,labs=labs,sortB=TRUE,verbose=TRUE)
  
}
