% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatenation.R
\name{/.tt_}
\alias{/.tt_}
\title{Concatenate textab blocks horizontally (side-by-side).}
\usage{
\method{/}{tt_}(left_block, right_block)
}
\arguments{
\item{left_block}{The left block of the tabular row.}

\item{right_block}{The right block of the tabular row.}
}
\value{
The output is a textab block, formed by horizontally concatenating the two provided textab blocks.
}
\description{
Concatenate textab blocks horizontally (side-by-side).
}
\examples{
# define some textab blocks
first_block = TexRow(c(1,2))
first_block

second_block = TexRow(3)
second_block

third_block = TexRow(4)
third_block

# concatenate two blocks horizontally
first_block / second_block

# concatenate three blocks horizontally
first_block / second_block / third_block

# concatenate both horizontally and vertically
# note: horizontal concatenation takes precedence over vertical concatenation
first_block + second_block / third_block

}
