% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_build_chunks.R
\name{nlp_build_chunks}
\alias{nlp_build_chunks}
\title{Build Chunks for NLP Analysis}
\usage{
nlp_build_chunks(tif, text_hierarchy, chunk_size, context_size)
}
\arguments{
\item{tif}{A data.table containing the text to be chunked.}

\item{text_hierarchy}{A character vector specifying the columns used for grouping and chunking.}

\item{chunk_size}{An integer specifying the size of each chunk.}

\item{context_size}{An integer specifying the size of the context around each chunk.}
}
\value{
A data.table with the chunked text and their respective contexts.
}
\description{
This function processes a data frame for NLP analysis by dividing text into chunks and providing context.
It generates chunks of text with a specified size and includes context based on the specified context size.
}
\examples{
# Creating a data frame
tif <- data.frame(doc_id = c('1', '1', '2'),
                 sentence_id = c('1', '2', '1'),
                 text = c("Hello world.",
                          "This is an example.",
                          "This is a party!"))

chunks <- nlp_build_chunks(tif,
                           chunk_size = 2,
                           context_size = 1,
                           text_hierarchy = c('doc_id', 'sentence_id'))
}
