% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_median_filter2d}
\alias{img_median_filter2d}
\title{Median filter2d}
\usage{
img_median_filter2d(
  image,
  filter_shape = list(3, 3),
  padding = "REFLECT",
  constant_values = 0,
  name = NULL
)
}
\arguments{
\item{image}{Either a 2-D Tensor of shape [height, width], a 3-D Tensor of
shape [height, width, channels], or a 4-D Tensor of
shape [batch_size, height, width, channels].}

\item{filter_shape}{An integer or tuple/list of 2 integers, specifying the height
and width of the 2-D median filter. Can be a single integer to specify the same
value for all spatial dimensions.}

\item{padding}{A string, one of "REFLECT", "CONSTANT", or "SYMMETRIC". The type
of padding algorithm to use, which is compatible with mode argument in tf.pad. For
more details, please refer to https://www.tensorflow.org/api_docs/python/tf/pad.}

\item{constant_values}{A scalar, the pad value to use in "CONSTANT" padding mode.}

\item{name}{A name for this operation (optional)}
}
\value{
3-D or 4-D `Tensor` of the same dtype as input.
}
\description{
Perform median filtering on image(s).
}
\section{Raises}{

ValueError: If `image` is not 2, 3 or 4-dimensional, if `padding` is other
than "REFLECT", "CONSTANT" or "SYMMETRIC", or if `filter_shape` is invalid.
}

