% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-methods.R
\name{tfd_stddev}
\alias{tfd_stddev}
\title{Standard deviation.}
\usage{
tfd_stddev(distribution, ...)
}
\arguments{
\item{distribution}{The distribution being used.}

\item{...}{Additional parameters passed to Python.}
}
\value{
a Tensor of shape \code{sample_shape(x) + self$batch_shape} with values of type \code{self$dtype}.
}
\description{
Standard deviation is defined as, stddev = \code{E[(X - E[X])**2]**0.5}
#' where X is the random variable associated with this distribution, E denotes expectation,
and \code{Var$shape = batch_shape + event_shape}.
}
\examples{
\dontrun{
  d <- tfd_normal(loc = c(1, 2), scale = c(1, 0.5))
  d \%>\% tfd_stddev()
}
}
\seealso{
Other distribution_methods: 
\code{\link{tfd_cdf}()},
\code{\link{tfd_covariance}()},
\code{\link{tfd_cross_entropy}()},
\code{\link{tfd_entropy}()},
\code{\link{tfd_kl_divergence}()},
\code{\link{tfd_log_cdf}()},
\code{\link{tfd_log_prob}()},
\code{\link{tfd_log_survival_function}()},
\code{\link{tfd_mean}()},
\code{\link{tfd_mode}()},
\code{\link{tfd_prob}()},
\code{\link{tfd_quantile}()},
\code{\link{tfd_sample}()},
\code{\link{tfd_survival_function}()},
\code{\link{tfd_variance}()}
}
\concept{distribution_methods}
