% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_stat_cols.R
\name{select_stat_cols}
\alias{select_stat_cols}
\title{Helper function to select only the relevant columns for statistical testing}
\usage{
select_stat_cols(data, by_set, metric, hypothesis)
}
\arguments{
\item{data}{\code{data.frame} of classification accuracy results}

\item{by_set}{\code{Boolean} specifying whether you want to compare feature sets (if \code{TRUE}) or individual features (if \code{FALSE}).}

\item{metric}{\code{character} denoting the classification performance metric to use in statistical testing. Can be one of \code{"accuracy"}, \code{"precision"}, \code{"recall"}, \code{"f1"}. Defaults to \code{"accuracy"}}

\item{hypothesis}{\code{character} denoting whether p-values should be calculated for each feature set or feature (depending on \code{by_set} argument) individually relative to the null if \code{use_null = TRUE} in \code{tsfeature_classifier} through \code{"null"}, or whether pairwise comparisons between each set or feature should be conducted on main model fits only through \code{"pairwise"}.}
}
\value{
object of class \code{data.frame}
}
\description{
Helper function to select only the relevant columns for statistical testing
}
\author{
Trent Henderson
}
