% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fips_codes.R
\docType{data}
\name{pums_variables}
\alias{pums_variables}
\title{Dataset with PUMS variables and codes}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 69400 rows and 12 columns.
}
\usage{
data(pums_variables)
}
\description{
Built-in dataset for variable name and code label lookup.
             To access the data directly, issue the command \code{data(pums_variables)}.

\itemize{
  \item \code{survey}: acs1 or acs5
  \item \code{year}: Year of data. For 5-year data, last year in range.
  \item \code{var_code}: Variable name
  \item \code{var_label}: Variable label
  \item \code{data_type}: chr or num
  \item \code{level}: housing or person
  \item \code{val_min}: For numeric variables, the minimum value
  \item \code{val_max}: For numeric variables, the maximum value
  \item \code{val_label}: Value label
  \item \code{recode}: Use labels to recode values
  \item \code{val_length}: Length of value returned
  \item \code{val_na}: Value of NA value returned by API (if known)
}
}
\details{
Dataset with PUMS variables and codes

Built-in dataset that is created from the
\href{https://www.census.gov/programs-surveys/acs/microdata/documentation.html}{Census
PUMS data dictionaries}. Use this dataset to lookup the names of variables to
use in \code{\link{get_pums}}. This dataset also contains labels for the
coded values returned by the Census API and is used when \code{recode = TRUE}
in \code{\link{get_pums}}.

Because variable names and codes change from year to year, you should filter
this dataset for the survey and year of interest. NOTE: 2017 - 2019 and 2021 acs1 and
2017 - 2021 acs5 variables are available.
}
\keyword{datasets}
