% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop-na-all.R
\name{drop_na_all}
\alias{drop_na_all}
\title{Drop rows containing all missing values}
\usage{
drop_na_all(data, ...)
}
\arguments{
\item{data}{A data frame.}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to inspect for
missing values. If empty, all columns are used.}
}
\value{
The original data frame with rows for which all values are missing dropped.
}
\description{
This is a convenient way to drop uninformative rows from a data frame.
}
\examples{
data <- tibble::tibble(
  a = c(NA, NA, NA), b = c(1, 1, NA), c = c(2, NA, NA)
)

drop_na_all(data)
drop_na_all(data, a, c)
}
\seealso{
\code{\link[tidyr:drop_na]{tidyr::drop_na}} and \code{\link{drop_uninformative_columns}}
}
