% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-replace_vec.R
\name{str_replace_vec}
\alias{str_replace_vec}
\title{String replace multiple strings}
\usage{
str_replace_vec(string, replace)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{replace}{A character vector where the names are the patterns to look
for and the values are the replacement values \code{(c(pattern1 = replacement1))}}
}
\value{
A character vector the same length as
\code{string}/\code{pattern}/\code{replacement}.
}
\description{
String replace multiple strings in a vector.
}
\details{
\code{str_replace_vec()} is a vectorized form of \code{\link[stringr:str_replace]{stringr::str_replace()}}.

This is different from passing a named vector to \code{\link[stringr:str_replace]{stringr::str_replace_all}},
which performs multiple replacements but to all pattern matches in a string.
}
\examples{
fruits <- c("two apples", "nine pears")
str_replace_vec(fruits, c("two" = "three", "nine" = "ten"))
}
\seealso{
\code{\link[stringr:str_replace]{stringr::str_replace()}} and \code{\link[stringr:str_replace]{stringr::str_replace_all()}}
}
