% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_text.R
\name{separate_text}
\alias{separate_text}
\title{Separate all matching text into multiple rows}
\usage{
separate_text(txt, pattern, column = "text")
}
\arguments{
\item{txt}{a tibble, usually results from \code{pmc_text}}

\item{pattern}{either a regular expression or a vector of words to find in
text}

\item{column}{column name, default "text"}
}
\value{
a tibble
}
\description{
Separate all matching text into multiple rows
}
\note{
passed to \code{grepl} and \code{str_extract_all}
}
\examples{
# doc <- pmc_xml("PMC2231364")
doc <- xml2::read_xml(system.file("extdata/PMC2231364.xml",
        package = "tidypmc"))
txt <- pmc_text(doc)
separate_text(txt, "[ATCGN]{5,}")
separate_text(txt, "\\\\([A-Z]{3,6}s?\\\\)")
# pattern can be a vector of words
separate_text(txt, c("hmu", "ybt", "yfe", "yfu"))
# wrappers for separate_text with extra step to expand matched ranges
separate_refs(txt)
separate_tags(txt, "YPO")

}
\author{
Chris Stubben
}
