% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rulelist.R
\name{plot.rulelist}
\alias{plot.rulelist}
\title{Plot method for rulelist}
\usage{
\method{plot}{rulelist}(x, thres_cluster_rows = 1000, dist_metric = "jaccard", ...)
}
\arguments{
\item{x}{A \link{rulelist}}

\item{thres_cluster_rows}{(positive integer) Maximum number of rows beyond
which a x-side dendrogram is not computed}

\item{dist_metric}{(string or function, default: "jaccard") Distance metric
for y-side (\code{rule_nbr}) passed to \code{method} argument of \link[proxy:dist]{proxy::dist}}

\item{...}{Arguments to be passed to \link[pheatmap:pheatmap]{pheatmap::pheatmap}}
}
\description{
Plots a heatmap with \code{rule_nbr}'s on x-side and clusters of
\code{row_nbr}'s on y-side of a binary matrix with 1 if a rule is applicable for
a row.
}
\details{
Number of clusters is set to min(number of unique rows in the
row_nbr X rule_nbr matrix and thres_cluster_rows)
}
\examples{
library("magrittr")
att = modeldata::attrition
tidy_c5 =
  C50::C5.0(Attrition ~., data = att, rules = TRUE) \%>\%
  tidy() \%>\%
  set_validation_data(att, "Attrition") \%>\%
  set_keys(NULL)

plot(tidy_c5)

}
