% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rulelist.R
\name{prune.rulelist}
\alias{prune.rulelist}
\title{\code{prune} rules of a \link{rulelist}}
\usage{
\method{prune}{rulelist}(
  tree,
  metrics_to_exclude = NULL,
  stop_expr_string = "relative__cumulative_coverage >= 0.9",
  min_n_rules = 1,
  ...
)
}
\arguments{
\item{tree}{A \link{rulelist}}

\item{metrics_to_exclude}{(character vector or NULL) Names of metrics not to
be calculated. See \link[=calculate.rulelist]{calculate} for the list of default
metrics.}

\item{stop_expr_string}{(string default: "relative__cumulative_coverage >=
0.9") Parsable condition}

\item{min_n_rules}{(positive integer) Minimum number of rules to keep}

\item{...}{Named list of custom metrics passed to
\link[=calculate.rulelist]{calculate}}
}
\value{
Object of class 'prune_ruleslist' with these components: 1. pruned:
ruleset keeping only first 'pos' rows. 2. n_pruned_rules: pos. If stop
criteria is never met, then pos = nrow(ruleset) 3. n_total_rules:
nrow(ruleset), 4. metrics_df: Dataframe with metrics and relative metrics
5. stop_expr_string
}
\description{
Prune the \link{rulelist} by suggesting to keep first 'k' rules based
on metrics computed by \link[=calculate.rulelist]{calculate}
}
\details{
\enumerate{
\item Metrics are computed using \link[=calculate.rulelist]{calculate}. 2.
Relative metrics (prepended by 'relative__') are calculated by dividing
each metric by its max value. 3. The first rule in rulelist order which
meets the 'stop_expr_string' criteria is stored (say 'pos'). Print method
suggests to keep rules until pos.
}
}
\examples{
library("magrittr")
model_c5  = C50::C5.0(Attrition ~., data = modeldata::attrition, rules = TRUE)
tidy_c5   = tidy(model_c5) \%>\%
            set_validation_data(modeldata::attrition, "Attrition") \%>\%
            set_keys(NULL)

#' prune with defaults
prune_obj = prune(tidy_c5)
#' note that all other metrics are visible in the print output
prune_obj
plot(prune_obj)
prune_obj$pruned

#' prune with a different stop_expr_string threshold
prune_obj = prune(tidy_c5,
                  stop_expr_string = "relative__cumulative_coverage >= 0.2"
                  )
prune_obj #' as expected, has smaller then 10 rules as compared to default args
plot(prune_obj)
prune_obj$pruned

#' prune with a different stop_expr_string metric
st = "relative__cumulative_overlap <= 0.7 & relative__cumulative_overlap > 0"
prune_obj = prune(tidy_c5, stop_expr_string = st)
prune_obj #' as expected, has smaller then 10 rules as compared to default args
plot(prune_obj)
prune_obj$pruned

}
\seealso{
\link{rulelist}, \link{tidy}, \link[=augment.rulelist]{augment},
\link[=predict.rulelist]{predict}, \link[=calculate.rulelist]{calculate},
\link[=prune.rulelist]{prune}, \link[=reorder.rulelist]{reorder}
}
