% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{varSpec}
\alias{varSpec}
\title{Get variable specification for a Cubist/C5 object}
\usage{
varSpec(object)
}
\arguments{
\item{object}{Cubist/C5 object}
}
\value{
A tidytable with three columns: variable(character), type(character)
and levels(a list-column). For numeric variables, levels are set to NA.
}
\description{
Obtain variable names, type (numeric, ordered, factor) and
levels as a tidytable
}
\examples{
\dontrun{
data("attrition", package = "modeldata")
cols_att = setdiff(colnames(attrition), c("MonthlyIncome", "Attrition"))

cb_att = Cubist::cubist(x = attrition[, cols_att],
                        y = attrition[["MonthlyIncome"]]
                        )
varSpec(cb_att)
}
}
\keyword{internal}
