% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_longer_delim.R
\name{separate_longer_delim}
\alias{separate_longer_delim}
\title{Split a string into rows}
\usage{
separate_longer_delim(.df, cols, delim, ...)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{cols}{Columns to separate}

\item{delim}{Separator delimiting collapsed values}

\item{...}{These dots are for future extensions and must be empty.}
}
\description{
If a column contains observations with multiple delimited values, separate
them each into their own row.
}
\examples{
df <- data.table(
  x = 1:3,
  y = c("a", "d,e,f", "g,h"),
  z = c("1", "2,3,4", "5,6")
)

df \%>\%
  separate_longer_delim(c(y, z), ",")
}
