% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinter.R
\name{tinter}
\alias{tinter}
\title{Generate shades, tints or both from a colour.}
\usage{
tinter(x, steps = 5, crop = 1, direction = "both", adjust = 0)
}
\arguments{
\item{x}{A string of a colour in any format accepted by grDevices::col2rgb().}

\item{steps}{An integer indicating how many shades/tints to generate (excluding x).}

\item{crop}{An integer indicating how many extreme colours to remove (e.g. crop = 1 eliminates 'black' and 'white').}

\item{direction}{A string indicating whether to include 'tints', 'shades' or 'both'.}

\item{adjust}{A number between -1 and 1. Values between 0 and -1 increasingly darken colour; values between 0 and 1 increasingly lighten colour.}
}
\value{
A vector of colours.
}
\description{
Generate shades, tints or both from a colour.
}
\examples{
tinter("blue")
tinter("#fa6a5c", steps = 10, crop = 3)
tinter("#fa6a5c", direction = "tints")
}
