% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{view}
\alias{view}
\title{View the focused part of a data structure}
\usage{
view(d, l)
}
\arguments{
\item{d}{The data structure to view}

\item{l}{The lens to apply}
}
\value{
The part of the data structure focused by the lens
}
\description{
\code{view()} applies a lens to a data structure and returns the focused part.

\code{set()} applies a lens to a data structure and sets the focused part.

\code{over()} applies a lens to a data structure and modifies the focused part using a function.
}
\examples{
x <- 1:10
names(x) <- letters[1:10]
view(x, names_l)
set(x, names_l, LETTERS[1:10])
over(x, names_l, toupper)
}
