% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_lines.R
\name{type_lines}
\alias{type_lines}
\title{Lines plot type}
\usage{
type_lines(type = "l", dodge = 0, fixed.dodge = FALSE)
}
\arguments{
\item{type}{1-character string giving the type of plot desired.  The
    following values are possible, for details, see \code{\link[base]{plot}}:
    \code{"p"} for points,
    \code{"l"} for lines,
    \code{"b"} for both points and lines,
    \code{"c"} for empty points joined by lines,
    \code{"o"} for overplotted points and lines,
    \code{"s"} and \code{"S"} for stair steps and
    \code{"h"} for histogram-like vertical lines.  Finally,
    \code{"n"} does not produce any points or lines.}

\item{dodge}{Adjustment parameter for dodging overlapping points or ranges in
grouped plots along the x-axis (or y-axis for flipped plots). Either:
\itemize{
\item numeric value in the range \verb{[0,1)}. Note that values are scaled
relative to the spacing of x-axis breaks, e.g. \code{dodge = 0.1} places the
outermost groups one-tenth of the way to adjacent breaks, \code{dodge = 0.5}
places them midway between breaks, etc. Values < 0.5 are recommended.
\item logical. If \code{TRUE}, the dodge width is calculated automatically based on
the number of groups (0.1 per group for 2-4 groups, 0.45 for 5+ groups). If
\code{FALSE} or 0, no dodging is performed.
}

Default value is 0 (no dodging). While we do not check, it is \emph{strongly}
recommended that dodging only be used in cases where the x-axis comprises a
limited number of discrete breaks.}

\item{fixed.dodge}{Logical. If \code{FALSE} (default), dodge positions are
calculated independently for each \code{x} value, based only on the groups
present at that position. If \code{TRUE}, dodge positions are based on all
groups, ensuring "fixed" spacing across x-axis breaks (i.e., even if some
groups are missing for a particular \code{x} value).}
}
\description{
Type function for plotting lines.
}
\examples{
# "l" type convenience character string
tinyplot(circumference ~ age | Tree, data = Orange, type = "l")

# Use `type_lines()` to pass extra arguments for customization
tinyplot(circumference ~ age | Tree, data = Orange, type = type_lines(type = "s"))

}
