% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_variance.R
\name{stability_variance}
\alias{stability_variance}
\title{Stability variance}
\usage{
stability_variance(data, trait, genotype, environment, unit.correct = FALSE)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analyzed.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties.}

\item{environment}{colname of a column containing a character or factor vector labeling different environments.}

\item{unit.correct}{logical, default is \code{FALSE}, returning the stability index with unit equals to squared unit of trait; when \code{TRUE}, returning stability index with the unit as same as unit of trait.#'}
}
\value{
a data table with stability variance
}
\description{
\code{stability_variance} calculate variance of a genotype across environments.
}
\details{
Stability variance (Shukla, 1972) is calculatd based on lindear combination of ecovalence and mean square of genotype-environment interaction.
Variety with low stability variance is considered as stable.
Negative values of stability variance is replaced with 0.
Equation of stability variance can be found in vignette file.
}
\examples{
data(Data)
stability.variance <- stability_variance(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment")
}
\references{
\insertRef{shukla1972}{toolStability}
}
\author{
Tien-Cheng Wang
}
\keyword{dynamic}
\keyword{stability}
