% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_glu}
\alias{nn_glu}
\title{GLU module}
\usage{
nn_glu(dim = -1)
}
\arguments{
\item{dim}{(int): the dimension on which to split the input. Default: -1}
}
\description{
Applies the gated linear unit function
\eqn{{GLU}(a, b)= a \otimes \sigma(b)} where \eqn{a} is the first half
of the input matrices and \eqn{b} is the second half.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(\ast_1, N, \ast_2)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(\ast_1, M, \ast_2)} where \eqn{M=N/2}
}
}

\examples{
if (torch_is_installed()) {
m <- nn_glu()
input <- torch_randn(4, 2)
output <- m(input)
}
}
