% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{untrace_package}
\alias{untrace_package}
\title{Untraces function calls from a package}
\usage{
untrace_package(pkg)
}
\arguments{
\item{pkg}{Package name to untrace.}
}
\value{
No return value, called for side effects
}
\description{
Removes tracing from all function calls in a package that were previously traced by \code{\link[=trace_package]{trace_package()}}.
}
\details{
This function reverses the effects of \code{trace_package} by removing all tracing from the specified package's functions.
}
\examples{
\dontrun{
local({
    trace_package("graphics", funign = "plot.default")
    on.exit(untrace_package("graphics"), add = TRUE)
    plot(1:10)
})
}
}
\seealso{
\code{\link[=trace_package]{trace_package()}}
}
\keyword{live}
