% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrac.R
\name{getTrac}
\alias{getTrac}
\title{Compute tracheidograms}
\usage{
getTrac(x, val50 = 120, mw = 5, scale = 1)
}
\arguments{
\item{x}{a vector with the light measurements (pixel gray-level values)}

\item{val50}{the value giving the "intensity" of the light measurements at which the measurments should be made (for more details please see the help of \code{tgram} function).}

\item{mw}{width of the rolling window to smooth the original data (for more details please see the help of \code{tgram} function)}

\item{scale}{distance per pixel, default = 1}
}
\value{
\code{getTrac} returns a list with following elements:

\code{n} number of cells

\code{pos} \code{pos$RingWidth} gives the tree-ring width and \code{pos$x} gives the "position" of each tracheid.

\code{LD} a \code{vector} with the lumen diameter (LD).

\code{CWT} a \code{vector} with the radial cell wall thikness (CWT).

\code{LWratio} a \code{vector} with the LD/CWT ratio.
}
\description{
This function computes a tracheidogram from microscope light measurements in gray (0-255).
}
\details{
This function uses the \code{tgram} function (tgram package) to convert gray pixel values (0-255) into a raw tracheidogram (keeping the original number of cells).
}
\examples{
## Not run:
y2010ray1 <- getTrac(tch$y2010$ray1, scale = 0.169)
y2010 <- getTrac(tch$y2010, scale = 0.169)
TCH <- lapply(tch,getTrac, scale = 0.169)
TCH$y2010$ray1$n #number of tracheids in ray1 in the year 2010
TCH$y2010$ray1$pos$RingWidth #number of tracheids in ray1 in the year 2010
#getTrac(tch$y2010$ray2, scale = 0.169)
#getTrac(data.frame(tch$y2010$ray2), scale=0.169)
## End(Not run)
}
\references{
DeSoto, L., De la Cruz, M., Fonti, P. (2011). Intra-annual patterns of tracheid size in the Mediterranean tree Juniperus thurifera as an indicator of seasonal water stress. Canadian Journal of Forest Research 41: 1280-1294.
Vaganov, E., 1989. The tracheidogram method in tree-ring analysis and its application, in: Cook, E., Kairiukstis, L. (Eds.), Methods of Dendrochronology: Applications in the Environmental Sciences. Kluwer Academic Publishers, Dordrecht, The Netherlands.
}
\seealso{
\code{tgram}
}

