% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_traits.R
\name{trait_np_bootstrap}
\alias{trait_np_bootstrap}
\title{Bootstrap traits}
\usage{
trait_np_bootstrap(filled_traits, nrep = 100, sample_size = 200, raw = FALSE)
}
\arguments{
\item{filled_traits}{output from the trait_fill function.}

\item{nrep}{number of bootstrap replicates}

\item{sample_size}{bootstrap size}

\item{raw}{logical; argument to extract the raw data of the trait
distributions.
The default is \code{raw = FALSE}. If \code{raw = TRUE}, \code{nrep} is restricted to 1 to
avoid memory issues.}
}
\value{
a tibble with columns for each grouping variable of \code{filled_traits}
(usually the elements of scale_hierarchy and the traits column),
and the moments mean, variance, skewness, and kurtosis.
}
\description{
Function for nonparametric bootstrap resampling to
calculate community weighted trait mean and higher moments.
}
\details{
The observed traits are re-sampled in proportion to their weights,
e.g. the abundance of a species or the biomass.
Values across all individuals
in a community are resampled \code{sample_size} times to incorporate the full
spectrum of trait variation, generating \code{nrep} trait distributions.
From these distributions the function estimates the mean and the higher
moments including variance, skewness and kurtosis.

#' The output of \code{trait_np_bootstrap()} can be summarized using
\code{trait_summarize_boot_moments()}.
}
\examples{
library(dplyr)
data(community)
data(trait)

# Filter community data to make example faster
community <- community |>
  filter(
    PlotID \%in\% c("A", "B"),
    Site == 1
  )
filled_traits <- trait_fill(
  comm = community,
  traits = trait,
  scale_hierarchy = c("Site", "PlotID"),
  taxon_col = "Taxon", value_col = "Value",
  trait_col = "Trait", abundance_col = "Cover"
)

boot_traits <- trait_np_bootstrap(filled_traits,
  nrep = 20,
  sample_size = 200
)
}
