% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmltvs.R
\name{mmltVS}
\alias{mmltVS}
\title{Select optimal subset based on high dimensional BIC in mmlts}
\usage{
mmltVS(
  mltargs,
  supp_max = NULL,
  k_max = NULL,
  thresh = NULL,
  init = TRUE,
  m_max = 10,
  verbose = TRUE,
  parallel = FALSE,
  m0 = NULL,
  future_args = list(strategy = "multisession", workers = supp_max),
  ...
)
}
\arguments{
\item{mltargs}{Arguments passed to \code{mmlt}}

\item{supp_max}{maximum support which to call \code{abess_tram} with.}

\item{k_max}{maximum support size to consider during the splicing algorithm.
Defaults to \code{supp}.}

\item{thresh}{threshold when to stop splicing. Defaults to
0.01 * \code{supp} * p * log(log(n)) / n$, where p denotes the number of predictors
and n the sample size.}

\item{init}{initialize active set. Defaults to \code{TRUE} and initializes the
active set with those covariates that are most correlated with score residuals
of an unconditional \code{modFUN(update(formula, . ~ 1))}.}

\item{m_max}{maximum number of iterating the splicing algorithm.}

\item{verbose}{show progress bar (default: \code{TRUE})}

\item{parallel}{toggle for parallel computing via
\code{\link[future.apply]{future_lapply}}}

\item{m0}{Transformation model for initialization}

\item{future_args}{arguments passed to \code{\link[future]{plan}}; defaults
to a \code{"multisession"} with \code{supp_max} workers}

\item{...}{
  Arguments passed on to \code{\link[=abess_mmlt]{abess_mmlt}}
  \describe{
    \item{\code{supp}}{support size of the coefficient vector}
  }}
}
\value{
object of class \code{"mltvs"}, containing the regularization path
    (information criterion \code{SIC} and coefficients \code{coefs}), the
     best fit (\code{best_fit}) and all other models (\code{all_fits})
}
\description{
Select optimal subset based on high dimensional BIC in mmlts
}
\details{
L0-penalized (i.e., best subset selection) multivariate
    transformation models using the abess algorithm.
}
