% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_modules.R
\name{check_nvidia_gpu}
\alias{check_nvidia_gpu}
\title{Install Necessary Python Modules}
\usage{
check_nvidia_gpu()
}
\description{
Installs required Python modules for the \{transforEmotion\} package, with automatic GPU detection
and optional GPU-enabled module installation.
}
\details{
This function performs the following steps:
\itemize{
  \item Checks for NVIDIA GPU availability
  \item If GPU is detected, prompts user to choose between CPU or GPU installation
  \item Installs core modules including transformers, torch, tensorflow, and other dependencies
  \item For GPU installations, sets up additional GPU-specific modules via \code{setup_gpu_modules()}
}

The function automatically manages dependencies and versions, ensuring compatibility
between CPU and GPU variants of packages like torch, tensorflow, and torchvision.
It uses \code{\link[reticulate]{conda_install}} for package management in the
'transforEmotion' conda environment.
}
\note{
Ensure that miniconda is installed and properly configured before running this function.
For GPU support, NVIDIA drivers must be properly installed on your system.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
