% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{apri}
\alias{apri}
\title{AST to Platelet Ratio (APRI)}
\usage{
apri(ast, plt, ast_uln = 40)
}
\arguments{
\item{ast}{numeric vector of serum AST levels in IU/l}

\item{plt}{numeric vector of platelet counts (10^9/l)}

\item{ast_uln}{single number value for lab upper limit of normal for AST levels (default is 40)}
}
\value{
numeric vector of APRI scores
}
\description{
A vectorised function to calculate the APRI score, a predictor of hepatic fibrosis.
}
\details{
Reference: Lin ZH, Xin YN, Dong QJ, et al. Performance of the aspartate aminotransferase-to-platelet
ratio index for the staging of hepatitis C-related fibrosis: an updated meta-analysis.
Hepatology 2011; 53:726-736.
}
\examples{
apri(ast = 38, plt = 150, ast_uln = 40)

# if the lab upper limit of normal is 40, ast_uln can be omitted
apri(ast = 160, plt = 75)
}
