% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uskdri.R
\name{kdpi_lookup}
\alias{kdpi_lookup}
\title{US KDPI lookup function}
\usage{
kdpi_lookup(kdri, scaling = 1)
}
\arguments{
\item{kdri}{numeric vector of KDRI values}

\item{scaling}{optional parameter for scaling factor (default is 1)}
}
\value{
numeric vector of KDPI percentiles
}
\description{
A vectorised function to convert kdri KDRI scores to KDPI percentiles. If the OPTN scaling factor was
not used when calculating the KDRI, it can be set here using the optional scaling parameter which
uses a default value of 1 (for no scaling).
}
\details{
This function requires the dplyr package to be installed.
}
\examples{
# if scaling factor was used when calculating KDRI
kdpi_lookup(1.25)

# if scaling factor for 2018 needs to be applied
kdpi_lookup(1.25, scaling =  1.2506957544151)
}
