% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr.R
\name{mdrd_US}
\alias{mdrd_US}
\title{eGFR by abbreviated MDRD equation (US units)}
\usage{
mdrd_US(creat, age, sex, ethnicity, offset = 0)
}
\arguments{
\item{creat}{numeric vector of serum creatinine in µmol/l (or mg/dl if units = "US")}

\item{age}{numeric vector of age in years (accepts integers or decimals)}

\item{sex}{character vector of sex ("F" for female, "M" for male)}

\item{ethnicity}{character vector of patient ethnicity, one of "black" or "non-black"}

\item{offset}{non-vectorised optional parameter for offset in years}
}
\value{
a numeric vector of eGFR values
}
\description{
A wrapper for the mdrd4v() vectorised function to calculate estimated glomerular filtration rate
using the abbreviated (four variable) MDRD equation, but using serum creatinine in mg/dl.
To allow for serial measurements over time, such as
for transplant follow-up data, there is an optional offset = n parameter which increases the age
value used in the equation by n years.
}
\details{
Reference: Levey AS, Greene T, Kusek JW, et al. A simplified equation to predict glomerular
filtration rate from serum creatinine. J Am Soc Nephrol 2000; 11:A0828.
}
\examples{
mdrd_US(creat = 1.5, age = 64.3, sex = "F", ethnicity = "black")
}
