% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nankivell_walser.R
\name{nankivell_spk_US}
\alias{nankivell_spk_US}
\title{eGFR using the Nankivell-SPK formula (US units)}
\usage{
nankivell_spk_US(SCr, Age, Sex, Weight, Height, Offset = 0)
}
\arguments{
\item{SCr}{numeric vector of serum creatinine in µmol/l (or mg/dl if units = "US")}

\item{Age}{numeric vector of patient ages in years}

\item{Sex}{character vector of sex ("F" for female, "M" for male)}

\item{Weight}{numeric vector of patient weights in kilograms}

\item{Height}{numeric vector of patient heights in metres}

\item{Offset}{non-vectorised optional numeric parameter for offset in years}
}
\value{
numeric vector of eGFR values
}
\description{
A wrapper function for the nankivell_spk() vectorised function to calculate the eGFR
using the Nankivell-SPK formula using serum creatinine in mg/dl.
To allow for serial measurements over time, such as
for transplant follow-up data, there is an optional offset = n parameter which increases the age
value used in the equation by n years. It has not been possible to run automated tests
to confirm the
accuracy of this function, so please use with caution.
}
\details{
Reference: Nankivell BJ, Chapman JR, Allen RD: Predicting glomerular filtration rate after
simultaneous pancreas and kidney transplantation. Clin Transplant 1995; 9(2): 129-134
}
\examples{
nankivell_spk_US(SCr = 1.33, Age = 74, Sex = "M", Weight = 172, Height = 172) # 49.0
}
