% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver_scores.R
\name{p_soft}
\alias{p_soft}
\title{P-SOFT Score}
\usage{
p_soft(Age, BMI, PrevTx, AbdoSurg, Albumin, Dx, ICU, Admitted, MELD,
  LifeSupport, Encephalopathy, PVThrombosis, Ascites, Units = "SI")
}
\arguments{
\item{Age}{numeric vector of patient ages in years}

\item{BMI}{numeric vector of patient BMI in kg/m2}

\item{PrevTx}{numeric vector of number of previous transplants}

\item{AbdoSurg}{numeric vector of whether previous abdominal surgery (1 = "yes", 0 = "no")}

\item{Albumin}{numeric vector of serum albumin in g/l}

\item{Dx}{numeric vector of whether on dialysis before transplant (1 = "yes", 0 = "no")}

\item{ICU}{numeric vector of whether patients in intensive care unit before transplant (1 = "yes", 0 = "no")}

\item{Admitted}{numeric vector of whether admitted to hospital pre-transplant (1 = "yes", 0 = "no")}

\item{MELD}{numeric vector of MELD scores}

\item{LifeSupport}{numeric vector of whether on life support pre-transplant (1 = "yes", 0 = "no")}

\item{Encephalopathy}{numeric vector of whether encephalopathy present (1 = "yes", 0 = "no")}

\item{PVThrombosis}{numeric vector of whether portal vein thrombosis (1 = "yes", 0 = "no")}

\item{Ascites}{numeric vector of whether ascites pre-transplant (1 = "yes", 0 = "no")}

\item{Units}{optional scalar for albumin units (one of "SI" for g/l, "US" for g/dl)}
}
\value{
numeric vector of P-SOFT scores
}
\description{
A vectorised function to calculate the pre-procurement component of the SOFT score used to
predict patient survival after liver transplantation. The function needs the MELD score as one of
its inputs - this is available using the transplantr::meld() function.
The units for albumin are g/l but this
is changed to g/dl if the optional Units parameter is set to "US"
}
\details{
Reference: Rana A, Hardy MA, Halazun KJ, et al. Survival Outcomes Following Liver Transplantation
(SOFT) Score: A Novel Method to Predict Patient Survival Following Liver Transplantation.
American Journal of Transplantation 2008; 8:2537-2546.
}
\examples{
p_soft(Age = 65, BMI = 36, PrevTx = 2, AbdoSurg = 1, Albumin = 29, Dx = 0,
    ICU = 0, Admitted = 1, MELD = 32, LifeSupport = 0, Encephalopathy = 1,
    PVThrombosis = 1, Ascites = 1) # 37
}
