% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver_scores.R
\name{pedi_soft}
\alias{pedi_soft}
\title{Pedi-SOFT Score}
\usage{
pedi_soft(CTVG, Weight, Dx, LifeSupport, PrevTx)
}
\arguments{
\item{CTVG}{numeric vector of whether cadaveric technical variant graft (1 for "yes", 0 for "no")}

\item{Weight}{numeric vector of recipient weight in kg}

\item{Dx}{numeric vector of whether on dialysis or creatinine clearance under 30 (1 for "yes", 0 for "no")}

\item{LifeSupport}{numeric vector of whether on life support pre-transplant (1 for "yes", 0 for "no")}

\item{PrevTx}{numeric vector of number of previous liver transplants}
}
\value{
numeric vector of Pedi-SOFT scores
}
\description{
A vectorised function to calculate the Pedi-SOFT score used to predict survival after
liver transplantation in children.
}
\details{
Reference: Rana A, Pallister ZS, Guiteau JJ, et al.
Survival Outcomes Following Pediatric Liver Transpantation (Pedi-SOFT) Score:
A Novel Predictive Index.
American Journal of Transplantation 2015; 15:1855-1863.
}
\examples{
pedi_soft(CTVG = 1, Weight = 10, Dx = 0, LifeSupport = 0, PrevTx = 0) # 4
}
