% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{peld_US}
\alias{peld_US}
\title{PELD score (US units)}
\usage{
peld_US(INR, bili, albumin, listing_age, growth_failure)
}
\arguments{
\item{INR}{numeric vector of INR}

\item{bili}{numeric vector of serum biliruin (mg/dl)}

\item{albumin}{numeric vector of serum albumin (g/dl)}

\item{listing_age}{numeric vector of age at the time of listing (years)}

\item{growth_failure}{numeric vector of whether there is growth failure (1 = yes, 0 = no)}
}
\value{
numeric vector of PELD scores
}
\description{
A wrapper for peld(), a vectorised function to generate a PELD score for paediatric liver
transplant candidates, using  mg/dl as the unit for the serum bilirubin level.
}
\details{
Reference: McDiarmid SV, Anand R, Lindblad AS, et. al. Development of a pediatric end-stage
liver disease score to predict poor outcome in children awaiting liver transplantation.
Transplantation 2002; 74(2):173-81.
}
\examples{
peld_US(INR = 2, bili = 3.1, albumin = 2.5, listing_age = 2, growth_failure = 1)
}
