% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{ukeld}
\alias{ukeld}
\title{UKELD score}
\usage{
ukeld(INR, bili, creat, Na, units = "SI")
}
\arguments{
\item{INR}{numeric vector of INR}

\item{bili}{numeric vector of bilirubin in µmol/l}

\item{creat}{numeric vector of creatinine in µmol/l}

\item{Na}{numeric vector of sodium in mmol/l}

\item{units}{Units for bilirubin and creatinine ("SI" for µmol/l (default), "US" for mg/dl)}
}
\value{
numeric vector of UKELD scores
}
\description{
A vectorised function to calculate the UKELD score using SI units for bilirubin and creatinine.
}
\details{
Reference: Barber KM, Madden S, Allen J, et al. Elective liver transplant list mortality:
development of a United Kingdom end-stage liver disease score. Transplantation
2011; 92(4):469-76.
}
\examples{
ukeld(INR = 1.0, bili = 212, creat = 54, Na = 126)
}
