% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echo_rb.R
\name{echo_rb}
\alias{echo_rb}
\title{Print RevBayes-formatted clade constriants.}
\usage{
echo_rb(tree, mrca_list, tip)
}
\arguments{
\item{tree}{Tree to which the tip will be added; object of type phylo}

\item{mrca_list}{Vector of taxa. The added tip will subtend the MRCA of these taxa}

\item{tip}{Taxon which will be added to the tree.}
}
\value{
vector A comma-separated list of all the taxa in the subtree to which the tip was added.
}
\description{
Once a tip has been added to the tree, print the subtree to which the tip was added. The output of this function is printed for use as a RevBayes clade constraint object.
}
\examples{
 mrca_list <- c("Ursus_arctos", "Ursus_spelaeus", "Ursus_americanus")
clade_constraint <- echo_rb(tree, mrca_list, "Ursus_abstrusus")
}
