% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{trending_model}
\alias{trending_model}
\alias{trending_models}
\alias{lm_model}
\alias{glm_model}
\alias{glm_nb_model}
\alias{brm_model}
\title{Modeling interface}
\usage{
lm_model(formula, ...)

glm_model(formula, family = gaussian, ...)

glm_nb_model(formula, ...)

brm_model(formula, ...)
}
\arguments{
\item{formula}{The formula of the model, with the response variable on the
left of a tilde symbol, and predictors on the right hand-side; variable
names used in the formula will need to be matched by columns in the \code{data}
input to other functions.}

\item{...}{Further arguments passed to the underlying models with the
exception of \code{data}.}

\item{family}{Link function to be used for the glm model.}
}
\value{
A \code{trending_model} object.
}
\description{
These functions wrap various modelling tools to ensure a consistent input
for \emph{trending} functions. They work by capturing the underlying model call
and decoupling it from the data specification. This makes it easy to use
the same underlying model specification and fitting procedure across
different data sets. See details for available model interfaces.
}
\details{
The following interfaces are available:
\itemize{
\item \code{lm_model}: interface for linear models implemented in
\code{\link[stats:lm]{stats::lm()}}.
\item \code{glm_model}: interface for generalised linear models (GLMs) implemented in
\code{\link[stats:glm]{stats::glm()}}.
\item \code{glm_nb_model}: interface for negative binomial generalied linear models
implemented in \code{\link[MASS:glm.nb]{MASS::glm.nb()}}.
\item \code{brm_model}: interface for Bayesian regression models implemented in
\code{\link[brms:brm]{brms::brm()}}.
}

These interfaces will accept the same inputs as the underlying model
functions but do not require, nor will they accept, a \code{data} argument.
Fitting is handled instead by the \code{\link[=fit]{fit()}} generic and associated methods.
}
\examples{
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))

poisson_model <- glm_model(y ~ x , family = "poisson")
negbin_model <- glm_nb_model(y ~ x)

}
\author{
Tim Taylor
}
